/*
 The Techlabs Pure MVC Tutorial
 Copyright (c) 2009 Pedro Furtado (pedro.furtado@gmail.com)
 Your reuse is governed by the Creative Commons Attribution 3.0 License
*/
package com.techlabs.puremvc.view
{
	import com.techlabs.puremvc.ApplicationFacade;
	import com.techlabs.puremvc.model.ConfigProxy;
	import com.techlabs.puremvc.model.DataProxy;
	import com.techlabs.puremvc.view.components.MainScreen;
	
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.net.URLRequest;
	import flash.net.navigateToURL;
	
	import mx.events.ListEvent;
	
	import org.puremvc.as3.interfaces.*;
	import org.puremvc.as3.patterns.mediator.Mediator;

	/**
	 * The main screen mediator, is in our case, where most of the action happens
	 * as it's the main screen of our application and you can consider it
	 * to mediate the user interactions with the required data operations.
	 * */
    public class MainScreenMediator extends Mediator implements IMediator
    {
        // Cannonical name of the Mediator
        public static const NAME:String = "MainScreenMediator";
        
		private var configProxy:ConfigProxy;
		private var dataProxy:DataProxy;
        /**
         * Constructor. 
         */
        public function MainScreenMediator( viewComponent:MainScreen ) 
        {
            // pass the viewComponent to the superclass where 
            // it will be stored in the inherited viewComponent property
            super( NAME, viewComponent );
			init()
        }
        
        private function init():void
		{
			//retrieve the required proxies
			dataProxy = facade.retrieveProxy(DataProxy.NAME) as DataProxy;
			configProxy = facade.retrieveProxy(ConfigProxy.NAME) as ConfigProxy;
			
			//add the listeners
			mainScreen.addFeed.addEventListener(MouseEvent.CLICK, addFeed);
			mainScreen.removeFeed.addEventListener(MouseEvent.CLICK, removeFeed);
			mainScreen.feedsList.dataProvider = dataProxy.feeds;
			
			mainScreen.feedsList.addEventListener(ListEvent.CHANGE, handleFeedListChange);
			mainScreen.postsList.addEventListener(ListEvent.CHANGE, handlePostListChange);
			
			mainScreen.goToPostButton.addEventListener(MouseEvent.CLICK, handleGoToClick);
			
			//and disable the gotopost button as an initial state, this could of course also 
			//be set in the mxml, but I think it makes more sense here.
			mainScreen.goToPostButton.enabled = false;
		}
		  /**
         * List all notifications this Mediator is interested in.
         * <P>
         * Automatically called by the framework when the mediator
         * is registered with the view.</P>
         * 
         * @return Array the list of Nofitication names
         */

		override public function listNotificationInterests():Array
		{
			return [ApplicationFacade.VIEW_ADD_FEED, 
					ApplicationFacade.VIEW_MAIN_SCREEN,
					ApplicationFacade.LOADING_FEED_COMPLETE];
		}
		
		override public function handleNotification(notification:INotification):void
		{
			switch(notification.getName())
			{
				case ApplicationFacade.VIEW_ADD_FEED:
					mainScreen.enabled = false;
				break;
				
				case ApplicationFacade.VIEW_MAIN_SCREEN:
					mainScreen.enabled = true;
				break;
			
				case ApplicationFacade.LOADING_FEED_COMPLETE:
					mainScreen.postsList.dataProvider = notification.getBody();
				break;
			}
		}
        /**
         * Cast the viewComponent to its actual type.
         * 
         * <P>
         * This is a useful idiom for mediators. The
         * PureMVC Mediator class defines a viewComponent
         * property of type Object. </P>
         * 
         * <P>
         * Here, we cast the generic viewComponent to 
         * its actual type in a protected mode. This 
         * retains encapsulation, while allowing the instance
         * (and subclassed instance) access to a 
         * strongly typed reference with a meaningful
         * name.</P>
         * 
         * @return MainScreen the viewComponent cast to org.puremvc.as3.demos.flex.appskeleton.view.components.MainScreen
         */
		 
        protected function get mainScreen():MainScreen
		{
            return viewComponent as MainScreen;
        }
		
		/*********************************/
		/* events handler 				 */
		/*********************************/
		
		private function handlePostListChange(e:ListEvent):void
		{
			var tmpXml:XML = e.itemRenderer.data as XML;
			//this xml hacking is required due to the way that rss feeds are served,
			//and although the most common approach is to do this server side this also works well
			//we could also use a RegEx but I chose to simplify the example.
			var tmpStr:String = tmpXml.toString().replace("content:encoded", "content").replace("content:encoded", "content")
			tmpXml = new XML(tmpStr)
			mainScreen.postText.htmlText = tmpXml.content
			mainScreen.goToPostButton.enabled = true;
		}
		
		private function handleGoToClick(e:MouseEvent):void
		{
			var tmpDt:* = mainScreen.postsList.selectedItem.data
			navigateToURL(new URLRequest(mainScreen.postsList.selectedItem.link));
		}
		
		private function handleFeedListChange(e:ListEvent):void
		{
			//get the feed
			mainScreen.goToPostButton.enabled = false;
			dataProxy.loadFeed(e.itemRenderer.data.feedUrl);
		}
		
		private function removeFeed(evt:MouseEvent):void
		{
			sendNotification(ApplicationFacade.REMOVE_FEED, mainScreen.feedsList.selectedIndex);
		}
		
		private function addFeed(evt:Event):void
		{
			
			sendNotification(ApplicationFacade.VIEW_ADD_FEED)
		}
    }
}